const express = require("express");
const router = express.Router();
const db = require("../models/db");

// Get unique sessions from the class table
router.get("/", async (req, res) => {
  try {
    const [results] = await db.query(
      "SELECT DISTINCT session FROM class ORDER BY session DESC"
    );
    res.json(results.map((result) => result.session));
  } catch (err) {
    console.error("Error fetching sessions:", err);
    res.status(500).json({ error: "Database error" });
  }
});

module.exports = router;
