const express = require("express");
const db = require("../models/db");
const router = express.Router();

// Get monthly performance data
router.get("/monthly", async (req, res) => {
  const query = `
    SELECT 
      MONTH(marks.date) AS month, 
      ROUND(AVG((marks.marks_obtained / marks.total_marks) * 100), 2) AS average_score
    FROM marks
    WHERE YEAR(marks.date) = YEAR(CURDATE())
    GROUP BY MONTH(marks.date)
    ORDER BY month;
  `;

  try {
    const [results] = await db.query(query);

    // Map results to include month names for easier frontend usage
    const monthlyPerformanceData = [
      { name: "Jan", average_score: 0 },
      { name: "Feb", average_score: 0 },
      { name: "Mar", average_score: 0 },
      { name: "Apr", average_score: 0 },
      { name: "May", average_score: 0 },
      { name: "Jun", average_score: 0 },
      { name: "Jul", average_score: 0 },
      { name: "Aug", average_score: 0 },
      { name: "Sep", average_score: 0 },
      { name: "Oct", average_score: 0 },
      { name: "Nov", average_score: 0 },
      { name: "Dec", average_score: 0 },
    ];

    // Populate monthly data with results
    results.forEach((result) => {
      monthlyPerformanceData[result.month - 1].average_score =
        result.average_score;
    });

    res.status(200).json(monthlyPerformanceData);
  } catch (error) {
    console.error("Error fetching monthly performance data:", error.message);
    res.status(500).json({ error: "Failed to fetch monthly performance data" });
  }
});

module.exports = router;
